using System;
using System.Collections.Generic;
using Android.Runtime;
using Java.Interop;

namespace Com.Handheld.Uhfr {

	// Metadata.xml XPath class reference: path="/api/package[@name='com.handheld.uhfr']/class[@name='PcUtils']"
	[global::Android.Runtime.Register ("com/handheld/uhfr/PcUtils", DoNotGenerateAcw=true)]
	public partial class PcUtils : global::Java.Lang.Object {
		static readonly JniPeerMembers _members = new XAPeerMembers ("com/handheld/uhfr/PcUtils", typeof (PcUtils));

		internal static IntPtr class_ref {
			get { return _members.JniPeerType.PeerReference.Handle; }
		}

		[global::System.Diagnostics.DebuggerBrowsable (global::System.Diagnostics.DebuggerBrowsableState.Never)]
		[global::System.ComponentModel.EditorBrowsable (global::System.ComponentModel.EditorBrowsableState.Never)]
		public override global::Java.Interop.JniPeerMembers JniPeerMembers {
			get { return _members; }
		}

		[global::System.Diagnostics.DebuggerBrowsable (global::System.Diagnostics.DebuggerBrowsableState.Never)]
		[global::System.ComponentModel.EditorBrowsable (global::System.ComponentModel.EditorBrowsableState.Never)]
		protected override IntPtr ThresholdClass {
			get { return _members.JniPeerType.PeerReference.Handle; }
		}

		[global::System.Diagnostics.DebuggerBrowsable (global::System.Diagnostics.DebuggerBrowsableState.Never)]
		[global::System.ComponentModel.EditorBrowsable (global::System.ComponentModel.EditorBrowsableState.Never)]
		protected override global::System.Type ThresholdType {
			get { return _members.ManagedPeerType; }
		}

		protected PcUtils (IntPtr javaReference, JniHandleOwnership transfer) : base (javaReference, transfer)
		{
		}

		// Metadata.xml XPath constructor reference: path="/api/package[@name='com.handheld.uhfr']/class[@name='PcUtils']/constructor[@name='PcUtils' and count(parameter)=0]"
		[Register (".ctor", "()V", "")]
		public unsafe PcUtils () : base (IntPtr.Zero, JniHandleOwnership.DoNotTransfer)
		{
			const string __id = "()V";

			if (((global::Java.Lang.Object) this).Handle != IntPtr.Zero)
				return;

			try {
				var __r = _members.InstanceMethods.StartCreateInstance (__id, ((object) this).GetType (), null);
				SetHandle (__r.Handle, JniHandleOwnership.TransferLocalRef);
				_members.InstanceMethods.FinishCreateInstance (__id, this, null);
			} finally {
			}
		}

		// Metadata.xml XPath method reference: path="/api/package[@name='com.handheld.uhfr']/class[@name='PcUtils']/method[@name='getPc' and count(parameter)=1 and parameter[1][@type='int']]"
		[Register ("getPc", "(I)Ljava/lang/String;", "")]
		public static unsafe string GetPc (int pcLen)
		{
			const string __id = "getPc.(I)Ljava/lang/String;";
			try {
				JniArgumentValue* __args = stackalloc JniArgumentValue [1];
				__args [0] = new JniArgumentValue (pcLen);
				var __rm = _members.StaticMethods.InvokeObjectMethod (__id, __args);
				return JNIEnv.GetString (__rm.Handle, JniHandleOwnership.TransferLocalRef);
			} finally {
			}
		}

		// Metadata.xml XPath method reference: path="/api/package[@name='com.handheld.uhfr']/class[@name='PcUtils']/method[@name='getValueLen' and count(parameter)=1 and parameter[1][@type='byte[]']]"
		[Register ("getValueLen", "([B)I", "")]
		public static unsafe int GetValueLen (byte[] value)
		{
			const string __id = "getValueLen.([B)I";
			IntPtr native_value = JNIEnv.NewArray (value);
			try {
				JniArgumentValue* __args = stackalloc JniArgumentValue [1];
				__args [0] = new JniArgumentValue (native_value);
				var __rm = _members.StaticMethods.InvokeInt32Method (__id, __args);
				return __rm;
			} finally {
				if (value != null) {
					JNIEnv.CopyArray (native_value, value);
					JNIEnv.DeleteLocalRef (native_value);
				}
				global::System.GC.KeepAlive (value);
			}
		}

		// Metadata.xml XPath method reference: path="/api/package[@name='com.handheld.uhfr']/class[@name='PcUtils']/method[@name='getValueLen' and count(parameter)=1 and parameter[1][@type='int']]"
		[Register ("getValueLen", "(I)I", "")]
		public static unsafe int GetValueLen (int byteLen)
		{
			const string __id = "getValueLen.(I)I";
			try {
				JniArgumentValue* __args = stackalloc JniArgumentValue [1];
				__args [0] = new JniArgumentValue (byteLen);
				var __rm = _members.StaticMethods.InvokeInt32Method (__id, __args);
				return __rm;
			} finally {
			}
		}

		// Metadata.xml XPath method reference: path="/api/package[@name='com.handheld.uhfr']/class[@name='PcUtils']/method[@name='getValueLen' and count(parameter)=1 and parameter[1][@type='java.lang.String']]"
		[Register ("getValueLen", "(Ljava/lang/String;)I", "")]
		public static unsafe int GetValueLen (string value)
		{
			const string __id = "getValueLen.(Ljava/lang/String;)I";
			IntPtr native_value = JNIEnv.NewString (value);
			try {
				JniArgumentValue* __args = stackalloc JniArgumentValue [1];
				__args [0] = new JniArgumentValue (native_value);
				var __rm = _members.StaticMethods.InvokeInt32Method (__id, __args);
				return __rm;
			} finally {
				JNIEnv.DeleteLocalRef (native_value);
			}
		}

		// Metadata.xml XPath method reference: path="/api/package[@name='com.handheld.uhfr']/class[@name='PcUtils']/method[@name='padRight' and count(parameter)=3 and parameter[1][@type='java.lang.String'] and parameter[2][@type='int'] and parameter[3][@type='char']]"
		[Register ("padRight", "(Ljava/lang/String;IC)Ljava/lang/String;", "")]
		public static unsafe string PadRight (string src, int len, char ch)
		{
			const string __id = "padRight.(Ljava/lang/String;IC)Ljava/lang/String;";
			IntPtr native_src = JNIEnv.NewString (src);
			try {
				JniArgumentValue* __args = stackalloc JniArgumentValue [3];
				__args [0] = new JniArgumentValue (native_src);
				__args [1] = new JniArgumentValue (len);
				__args [2] = new JniArgumentValue (ch);
				var __rm = _members.StaticMethods.InvokeObjectMethod (__id, __args);
				return JNIEnv.GetString (__rm.Handle, JniHandleOwnership.TransferLocalRef);
			} finally {
				JNIEnv.DeleteLocalRef (native_src);
			}
		}

	}
}
